using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;

namespace Xanthos.Evo
{
	[CorpseName( "a daemon corpse" )]
	public class RaelisDemonio : BaseEvo, IEvoCreature
	{
		public override BaseEvoSpec GetEvoSpec()
		{
			return RaelisDemonioSpec.Instance;
		}

		public override BaseEvoEgg GetEvoEgg()
		{
			return new RaelisDemonioEgg();
		}
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.ArmorIgnore;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}

		public override bool AddPointsOnDamage { get { return false; } }
		public override bool AddPointsOnMelee { get { return true; } }
		public override Type GetEvoDustType() { return typeof( RaelisDemonioDust ); }
		
      public virtual void AlterSpellDamageTo(Mobile to, ref int damage)
      {
          damage += 1 + (int)(damage * 0.75);
      }

		public override bool HasBreath{ get{ return true; } }

		public RaelisDemonio( string name ) : base( name, AIType.AI_Mage, 0.01 )
		{
		}

		public RaelisDemonio( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write( (int)0 );			
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}